<?php

namespace App\Controller;

use App\Controller\Admin\Crud\StudentNoteCrudController;
use App\Controller\Educator\Crud\StudentNoteCrudEducatorController;
use App\Entity\Student;
use App\Entity\StudentNote;
use App\Entity\User;
use App\Form\CreateStudentNoteType;
use App\Services\Mailer;
use App\Services\NotificationService;
use App\Services\PushNotifier;
use App\Services\UserSubscriptionManager;
use DateTimeImmutable;
use Doctrine\ORM\EntityManagerInterface;
use EasyCorp\Bundle\EasyAdminBundle\Config\Action;
use EasyCorp\Bundle\EasyAdminBundle\Router\AdminUrlGenerator;
use Exception;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Symfony\Contracts\Translation\TranslatorInterface;

#[Route('/poznamka', name: 'app_student_note_')]
#[IsGranted(User::ROLE_EDUCATOR)]
class StudentNoteController extends AbstractController
{
    /**
     * @throws Exception
     */
    #[Route('/vytvorit/{id}', name: 'create')]
    public function index(Student $student, Request $request, AdminUrlGenerator $adminUrlGenerator, EntityManagerInterface $entityManager,
                          Mailer $mailer, UserSubscriptionManager $userSubscriptionManager, PushNotifier $pushNotifier, TranslatorInterface $translator): Response
    {
        /** @var User $user */
        $user = $this->getUser();
        $educator = $user->getEducator();
        $studentNote = new StudentNote();
        $studentNote->setEducator($educator);
        $studentNote->setStudent($student);
        $form = $this->createForm(CreateStudentNoteType::class, $studentNote);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $studentNote->setTime(new DateTimeImmutable());
            $entityManager->persist($studentNote);
            $entityManager->flush();
            $notificationService = new NotificationService($userSubscriptionManager, $adminUrlGenerator, $pushNotifier, $translator);
            $notificationService->createNotificationsForStudentNote($mailer, $studentNote);
            $entityManager->flush();
            $controller = in_array('ROLE_ADMIN', $this->getUser()->getRoles()) ? StudentNoteCrudController::class : StudentNoteCrudEducatorController::class;
            $url = $adminUrlGenerator
                ->setDashboard($user->getDashboard())
                ->setController($controller)
                ->setAction(Action::INDEX)
                ->generateUrl();
            return $this->redirect($url);
        }

        return $this->render('basic_form.html.twig', [
            'form' => $form,
            'templateUrl' => null,
        ]);
    }
}
