<?php

namespace App\Controller;

use App\Entity\User;
use App\Form\User\ChangePasswordFormType;
use App\Form\User\EditUserInformationFormType;
use App\Repository\UserRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/pouzivatel', name: 'app_user_')]
#[IsGranted('ROLE_USER')]
class UserController extends AbstractController
{
    #[Route('/profil', name: 'profile')]
    public function index(Request $request): Response
    {
        /** @var User $user */
        $user = $this->getUser();
        if (!$user) {
            throw $this->createNotFoundException('User not found');
        }
        return $this->render('user/profile.html.twig', [
            'user' => $user,
        ]);
    }
    #[Route('/uprav-profil', name: 'edit_profile')]
    #[IsGranted(new Expression('is_granted("ROLE_ADMIN") or is_granted("ROLE_EDUCATOR")'))]
    public function editProfile(Request $request, EntityManagerInterface $entityManager): Response
    {
        /** @var User $user */
        $user = $this->getUser();
        if (!$user) {
            throw $this->createNotFoundException('User not found');
        }
        $form = $this->createForm(EditUserInformationFormType::class, $user);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            $this->addFlash('success', 'entity.user.flash_success_info_edit');
            $this->redirectToRoute('app_user_profile');
        }

        return $this->render('basic_form.html.twig', [
            'user' => $user,
            'form' => $form,
            'templateUrl' => null,
        ]);
    }
    #[Route('/zmen-heslo', name: 'change_password')]
    public function changePassword(Request $request, UserPasswordHasherInterface $passwordHasher, EntityManagerInterface $entityManager): Response
    {
        /** @var User $user */
        $user = $this->getUser();
        if (!$user) {
            throw $this->createNotFoundException('User not found');
        }
        $form = $this->createForm(ChangePasswordFormType::class);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $encodedPassword = $passwordHasher->hashPassword(
                $user,
                $form->get('plainPassword')->getData()
            );

            $user->setPassword($encodedPassword);
            $entityManager->flush();

            $this->addFlash('success', 'entity.user.flash_success_password_edit');
            $this->redirectToRoute('app_user_profile');
        }

        return $this->render('basic_form.html.twig', [
            'user' => $user,
            'form' => $form,
            'templateUrl' => null,
        ]);
    }
}
