<?php

namespace App\Entity;

use App\Repository\ActivityRepository;
use App\Services\GeneralFunctionsService;
use DateTimeImmutable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use App\Validator\Constraints as CustomAssert;
use Exception;
use Symfony\Component\Validator\Constraints as Assert;


#[ORM\Entity(repositoryClass: ActivityRepository::class)]
#[CustomAssert\FromTimeIsLessThanEndTime]
class Activity
{
    const TRAINING = 'training';
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: Types::TIME_IMMUTABLE)]
    private ?DateTimeImmutable $fromTime = null;

    #[ORM\Column(type: Types::TIME_IMMUTABLE)]
    private ?DateTimeImmutable $toTime = null;

    #[ORM\Column(type: Types::SMALLINT)]
    private ?int $dayInWeek = null;

    #[ORM\ManyToMany(targetEntity: Student::class, inversedBy: 'activities')]
    private Collection $students;

    #[ORM\ManyToOne(inversedBy: 'trainings')]
    #[ORM\JoinColumn(nullable: false)]
    #[Assert\NotBlank()]
    private ?Coach $coach = null;

    #[ORM\Column(length: 255)]
    private ?string $type = null;

    /**
     * @throws Exception
     */
    public function getTypeToText(): string
    {
        switch ($this->type) {
            case Activity::TRAINING: {
                return 'entity.activity.type.training.singular_name';
            }
            default:
                throw new Exception('unknown type');
        }
    }
    public function __construct()
    {
        $this->students = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFromTime(): ?DateTimeImmutable
    {
        return $this->fromTime;
    }

    public function setFromTime(DateTimeImmutable $fromTime): static
    {
        $this->fromTime = $fromTime;

        return $this;
    }

    public function getToTime(): ?DateTimeImmutable
    {
        return $this->toTime;
    }

    public function setToTime(DateTimeImmutable $toTime): static
    {
        $this->toTime = $toTime;

        return $this;
    }

    public function getDayInWeek(): ?int
    {
        return $this->dayInWeek;
    }

    public function setDayInWeek(int $dayInWeek): static
    {
        $this->dayInWeek = $dayInWeek;

        return $this;
    }

    /**
     * @return Collection<int, Student>
     */
    public function getStudents(): Collection
    {
        return $this->students;
    }

    public function addStudent(Student $student): static
    {
        if (!$this->students->contains($student)) {
            $this->students->add($student);
        }

        return $this;
    }

    public function removeStudent(Student $student): static
    {
        $this->students->removeElement($student);

        return $this;
    }

    public function getCoach(): ?Coach
    {
        return $this->coach;
    }

    public function setCoach(?Coach $coach): static
    {
        $this->coach = $coach;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(string $type): static
    {
        $this->type = $type;

        return $this;
    }
}
