<?php

namespace App\Entity;

use App\Repository\CoachRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;


#[ORM\Entity(repositoryClass: CoachRepository::class)]
class Coach
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToMany(targetEntity: Student::class, inversedBy: 'coaches')]
    private Collection $students;

    #[ORM\ManyToOne(cascade: ['persist'], inversedBy: 'coaches')]
    #[ORM\JoinColumn(nullable: false)]
    #[Assert\Valid]
    private ?User $user = null;

    #[ORM\OneToMany(mappedBy: 'coach', targetEntity: Activity::class)]
    private Collection $trainings;

    public function __construct()
    {
        $this->students = new ArrayCollection();
        $this->trainings = new ArrayCollection();
    }
    public function __toString(): string
    {
        return $this->user->getFirstName() . ' ' . $this->user->getLastName(). ' ' .$this->user->getEmail();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return Collection<int, Student>
     */
    public function getStudents(): Collection
    {
        return $this->students;
    }

    public function addStudent(Student $student): static
    {
        if (!$this->students->contains($student)) {
            $this->students->add($student);
        }

        return $this;
    }

    public function removeStudent(Student $student): static
    {
        $this->students->removeElement($student);

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): static
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection<int, Activity>
     */
    public function getTrainings(): Collection
    {
        return $this->trainings;
    }

    public function addTraining(Activity $training): static
    {
        if (!$this->trainings->contains($training)) {
            $this->trainings->add($training);
            $training->setCoach($this);
        }

        return $this;
    }

    public function removeTraining(Activity $training): static
    {
        if ($this->trainings->removeElement($training)) {
            // set the owning side to null (unless already changed)
            if ($training->getCoach() === $this) {
                $training->setCoach(null);
            }
        }

        return $this;
    }
}
