<?php

namespace App\Entity;

use App\Repository\DormitoryCardRepository;
use DateTimeImmutable;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

#[ORM\Entity(repositoryClass: DormitoryCardRepository::class)]
#[UniqueEntity('number')]
#[UniqueEntity('student')]
class DormitoryCard
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, unique: true)]
    private ?string $number = null;

    #[ORM\ManyToOne(inversedBy: 'dormitoryCards')]
    private ?Student $student = null;

    #[ORM\Column]
    private ?DateTimeImmutable $creationTime = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNumber(): ?string
    {
        return $this->number;
    }

    public function setNumber(string $number): static
    {
        $this->number = $number;

        return $this;
    }

    public function getStudent(): ?Student
    {
        return $this->student;
    }

    public function setStudent(?Student $student): static
    {
        $this->student = $student;

        return $this;
    }

    public function getCreationTime(): ?DateTimeImmutable
    {
        return $this->creationTime;
    }

    public function setCreationTime(DateTimeImmutable $creationTime): static
    {
        $this->creationTime = $creationTime;

        return $this;
    }
}
