<?php

namespace App\Entity;

use App\Repository\GuardianRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: GuardianRepository::class)]
class Guardian
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToMany(targetEntity: Student::class, inversedBy: 'guardians')]
    private Collection $children;

    #[ORM\ManyToOne(cascade: ['persist'], inversedBy: 'guardians')]
    #[ORM\JoinColumn(nullable: false)]
    #[Assert\Valid]
    private ?User $user = null;

    public function __construct()
    {
        $this->children = new ArrayCollection();
    }
    public function __toString(): string
    {
        return $this->user->getFirstName() . ' ' . $this->user->getLastName(). ' ' .$this->user->getEmail();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return Collection<int, Student>
     */
    public function getChildren(): Collection
    {
        return $this->children;
    }

    public function addChild(Student $child): static
    {
        if (!$this->children->contains($child)) {
            $this->children->add($child);
        }

        return $this;
    }

    public function removeChild(Student $child): static
    {
        $this->children->removeElement($child);

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): static
    {
        $this->user = $user;

        return $this;
    }
}
