<?php

namespace App\Entity;

use App\Repository\MailNotificationRepository;
use DateTimeImmutable;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: MailNotificationRepository::class)]
class MailNotification
{
    public const NEW_STUDENT_NOTE_TYPE = 0;
    public const COMPLETE_EVENING_CHECK_TYPE = 1;
    public const INCOMPLETE_EVENING_CHECK_TYPE = 2;
    public const NEW_USER_TYPE = 3;
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $subject = null;

    #[ORM\ManyToOne(inversedBy: 'mailNotifications')]
    #[ORM\JoinColumn(nullable: true)]
    private ?User $receiver = null;

    #[ORM\Column(type: Types::SMALLINT)]
    private ?int $type = null;

    #[ORM\Column(nullable: true)]
    private ?bool $sent = null;

    #[ORM\Column]
    private ?DateTimeImmutable $creationTime = null;

    #[ORM\Column(type: Types::ARRAY, nullable: true)]
    private ?array $options = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSubject(): ?string
    {
        return $this->subject;
    }

    public function setSubject(string $subject): static
    {
        $this->subject = $subject;

        return $this;
    }

    public function getReceiver(): ?User
    {
        return $this->receiver;
    }

    public function setReceiver(?User $receiver): static
    {
        $this->receiver = $receiver;

        return $this;
    }

    public function getType(): ?int
    {
        return $this->type;
    }

    public function setType(int $type): static
    {
        $this->type = $type;

        return $this;
    }

    public function isSent(): ?bool
    {
        return $this->sent;
    }

    public function setSent(?bool $sent): static
    {
        $this->sent = $sent;

        return $this;
    }

    public function getCreationTime(): ?DateTimeImmutable
    {
        return $this->creationTime;
    }

    public function setCreationTime(DateTimeImmutable $creationTime): static
    {
        $this->creationTime = $creationTime;

        return $this;
    }

    public function getOptions(): ?array
    {
        return $this->options;
    }

    public function setOptions(?array $options): static
    {
        $this->options = $options;

        return $this;
    }
}
