<?php

namespace App\Entity;

use App\Repository\MeetingRepository;
use DateTimeImmutable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: MeetingRepository::class)]
class Meeting
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(nullable: true)]
    private ?DateTimeImmutable $plannedDate = null;

    #[ORM\ManyToOne(inversedBy: 'meetings')]
    private ?Educator $educator = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $educatorNote = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $studentNote = null;

    #[ORM\OneToMany(mappedBy: 'meeting', targetEntity: MeetingAttendance::class, cascade: ['persist'])]
    private Collection $meetingAttendances;

    #[ORM\Column(type: Types::SMALLINT)]
    private ?int $doorNumber = null;
    public function isStudentInMessageReceivers(Student $student): bool
    {
        /** @var MeetingAttendance $meetingAttendance */
        foreach ($this->meetingAttendances as $meetingAttendance) {
            if ($student === $meetingAttendance->getStudent()) {
                return true;
            }
        }
        return false;
    }
    public function __construct()
    {
        $this->meetingAttendances = new ArrayCollection();
    }


    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPlannedDate(): ?DateTimeImmutable
    {
        return $this->plannedDate;
    }

    public function setPlannedDate(?DateTimeImmutable $plannedDate): static
    {
        $this->plannedDate = $plannedDate;

        return $this;
    }

    public function getEducator(): ?Educator
    {
        return $this->educator;
    }

    public function setEducator(?Educator $educator): static
    {
        $this->educator = $educator;

        return $this;
    }

    public function getEducatorNote(): ?string
    {
        return $this->educatorNote;
    }

    public function setEducatorNote(?string $educatorNote): static
    {
        $this->educatorNote = $educatorNote;

        return $this;
    }

    public function getStudentNote(): ?string
    {
        return $this->studentNote;
    }

    public function setStudentNote(?string $studentNote): static
    {
        $this->studentNote = $studentNote;

        return $this;
    }

    /**
     * @return Collection<int, MeetingAttendance>
     */
    public function getMeetingAttendances(): Collection
    {
        return $this->meetingAttendances;
    }

    public function addMeetingAttendance(MeetingAttendance $meetingAttendance): static
    {
        if (!$this->meetingAttendances->contains($meetingAttendance)) {
            $this->meetingAttendances->add($meetingAttendance);
            $meetingAttendance->setMeeting($this);
        }

        return $this;
    }

    public function removeMeetingAttendance(MeetingAttendance $meetingAttendance): static
    {
        if ($this->meetingAttendances->removeElement($meetingAttendance)) {
            // set the owning side to null (unless already changed)
            if ($meetingAttendance->getMeeting() === $this) {
                $meetingAttendance->setMeeting(null);
            }
        }

        return $this;
    }

    public function getDoorNumber(): ?int
    {
        return $this->doorNumber;
    }

    public function setDoorNumber(int $doorNumber): static
    {
        $this->doorNumber = $doorNumber;

        return $this;
    }

    public function getAll(): ?bool
    {
        return $this->all;
    }

    public function setAll(?bool $all): void
    {
        $this->all = $all;
    }

}
