<?php

namespace App\Entity;

use App\Repository\MeetingAttendanceRepository;
use Doctrine\ORM\Mapping as ORM;
use Exception;

#[ORM\Entity(repositoryClass: MeetingAttendanceRepository::class)]
class MeetingAttendance
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(targetEntity: Student::class, inversedBy: 'meetingAttendances')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Student $student = null;

    #[ORM\ManyToOne(targetEntity: Meeting::class,inversedBy: 'meetingAttendances')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Meeting $meeting = null;

    #[ORM\Column(nullable: true)]
    private ?bool $present = null;

    /**
     * @throws Exception
     */
    public function isPresentToText (): string
    {
        switch ($this->present) {
            case true: {
                return 'entity.attendance.action.present.singular_name';
            }
            case false: {
                return 'entity.attendance.action.absent.singular_name';
            }
            case null: {
                return 'general.n/a';
            }
            default:
                throw new Exception('unknown present value');
        }

    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStudent(): ?Student
    {
        return $this->student;
    }

    public function setStudent(?Student $student): static
    {
        $this->student = $student;

        return $this;
    }

    public function getMeeting(): ?Meeting
    {
        return $this->meeting;
    }

    public function setMeeting(?Meeting $meeting): static
    {
        $this->meeting = $meeting;

        return $this;
    }

    public function isPresent(): ?bool
    {
        return $this->present;
    }

    public function setPresent(?bool $present): static
    {
        $this->present = $present;

        return $this;
    }
}
