<?php

namespace App\Entity;

use App\Repository\RoomRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: RoomRepository::class)]
#[UniqueEntity(['doorNumber'], 'validator.unique_door_number')]
class Room
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: Types::SMALLINT)]
    private ?int $doorNumber = null;

    #[ORM\Column(type: Types::SMALLINT)]
    private ?int $floor = null;

    #[ORM\OneToMany(mappedBy: 'room', targetEntity: Student::class)]
    #[Assert\Count(max: 2, maxMessage: 'validator.invalid_count_students_in_room')]
    private Collection $students;

    public function __construct()
    {
        $this->students = new ArrayCollection();
    }

    public function __toString(): string
    {
        return $this->floor . '.poschodie č.' . $this->doorNumber;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDoorNumber(): ?int
    {
        return $this->doorNumber;
    }

    public function setDoorNumber(int $doorNumber): static
    {
        $this->doorNumber = $doorNumber;

        return $this;
    }

    public function getFloor(): ?int
    {
        return $this->floor;
    }

    public function setFloor(int $floor): static
    {
        $this->floor = $floor;

        return $this;
    }

    /**
     * @return Collection<int, Student>
     */
    public function getStudents(): Collection
    {
        return $this->students;
    }

    public function addStudent(Student $student): static
    {
        if (!$this->students->contains($student)) {
            $this->students->add($student);
            $student->setRoom($this);
        }

        return $this;
    }

    public function removeStudent(Student $student): static
    {
        if ($this->students->removeElement($student)) {
            // set the owning side to null (unless already changed)
            if ($student->getRoom() === $this) {
                $student->setRoom(null);
            }
        }

        return $this;
    }
    public function containsStudentEmail(string $email): bool
    {
        foreach ($this->students as $student){
            if ($student->getUser()->getEmail() === $email) {
                return true;
            }
        }
        return false;
    }
}
