<?php

namespace App\Entity;

use App\Repository\ScheduleRepository;
use DateTimeImmutable;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use App\Validator\Constraints as CustomAssert;


#[ORM\Entity(repositoryClass: ScheduleRepository::class)]
#[CustomAssert\TimeSchedule]

class Schedule
{
    public static array $FROM_TIME = [];
    public static array $TO_TIME = [];
    const TRANSFORM_SCHEDULE = [
        self::P7_KEY => ['from' => '15:00',
            'to' => '22:00'],
        self::P8_KEY => ['from' => '14:00',
            'to' => '22:00'],
        self::N8_KEY => ['from' => '22:00',
            'to' => '06:00'],
        self::N10_KEY => ['from' => '20:00',
            'to' => '06:00'],
        self::R8_KEY => ['from' => '06:00',
            'to' => '14:00'],
    ];
    const P7_KEY = 'P7';
    const P8_KEY = 'P8';
    const P_KEY = 'P';
    const N8_KEY = 'N8';
    const N10_KEY = 'N10';
    const R8_KEY = 'R8';
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: Types::SMALLINT)]
    private ?int $week = null;

    #[ORM\Column(type: Types::SMALLINT)]
    private ?int $dayInWeek = null;

    #[ORM\Column(type: Types::TIME_IMMUTABLE, nullable: true)]
    private ?DateTimeImmutable $fromTime = null;

    #[ORM\Column(type: Types::TIME_IMMUTABLE, nullable: true)]
    private ?DateTimeImmutable $toTime = null;

    #[ORM\ManyToOne(inversedBy: 'schedules')]
    #[ORM\JoinColumn(nullable: true)]
    private ?Educator $educator = null;

    public static function initFromTimeAndToTime(): void
    {
        self::$FROM_TIME['06:00'] = new DateTimeImmutable('06:00');
        self::$FROM_TIME['14:00'] = new DateTimeImmutable('14:00');
        self::$FROM_TIME['15:00'] = new DateTimeImmutable('15:00');
        self::$FROM_TIME['20:00'] = new DateTimeImmutable('20:00');
        self::$FROM_TIME['22:00'] = new DateTimeImmutable('22:00');

        self::$TO_TIME['06:00'] = new DateTimeImmutable('06:00');
        self::$TO_TIME['14:00'] = new DateTimeImmutable('14:00');
        self::$TO_TIME['22:00'] = new DateTimeImmutable('22:00');
    }
    public function getId(): ?int
    {
        return $this->id;
    }

    public function getWeek(): ?int
    {
        return $this->week;
    }

    public function setWeek(int $week): static
    {
        $this->week = $week;

        return $this;
    }

    public function getDayInWeek(): ?int
    {
        return $this->dayInWeek;
    }

    public function setDayInWeek(int $dayInWeek): static
    {
        $this->dayInWeek = $dayInWeek;

        return $this;
    }

    public function getFromTime(): ?DateTimeImmutable
    {
        return $this->fromTime;
    }

    public function setFromTime(?DateTimeImmutable $fromTime): static
    {
        $this->fromTime = $fromTime;

        return $this;
    }

    public function getToTime(): ?DateTimeImmutable
    {
        return $this->toTime;
    }

    public function setToTime(?DateTimeImmutable $toTime): static
    {
        $this->toTime = $toTime;

        return $this;
    }

    public function getEducator(): ?Educator
    {
        return $this->educator;
    }

    public function setEducator(?Educator $educator): static
    {
        $this->educator = $educator;

        return $this;
    }
}
