<?php

namespace App\Entity;

use App\Repository\UserSubscriptionRepository;
use BenTools\WebPushBundle\Model\Subscription\UserSubscriptionInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Security\Core\User\UserInterface;

#[ORM\Entity(repositoryClass: UserSubscriptionRepository::class)]
class UserSubscription implements UserSubscriptionInterface
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    private User $user;
    #[ORM\Column(length: 255)]
    private ?string $subscriptionHash;

    #[ORM\Column(type: Types::JSON)]
    private array $subscription;

    #[ORM\ManyToMany(targetEntity: PushNotification::class, mappedBy: 'subscriptions')]
    private Collection $pushNotifications;
    public function __construct(User $user, string $subscriptionHash, array $subscription)
    {
        $this->user = $user;
        $this->subscriptionHash = $subscriptionHash;
        $this->subscription = $subscription;
        $this->pushNotifications = new ArrayCollection();
    }
    public function getId(): ?int
    {
        return $this->id;
    }

    public function getUser(): User
    {
        return $this->user;
    }

    public function setUser(?User $user): static
    {
        $this->user = $user;

        return $this;
    }

    public function getSubscriptionHash(): string
    {
        return $this->subscriptionHash;
    }

    public function setSubscriptionHash(string $subscriptionHash): static
    {
        $this->subscriptionHash = $subscriptionHash;

        return $this;
    }

    public function getSubscription(): array
    {
        return $this->subscription;
    }

    public function setSubscription(array $subscription): static
    {
        $this->subscription = $subscription;

        return $this;
    }
    public function getEndpoint(): string
    {
        return $this->subscription['endpoint'];
    }

    public function getPublicKey(): string
    {
        return $this->subscription['keys']['p256dh'];
    }

    public function getAuthToken(): string
    {
        return $this->subscription['keys']['auth'];
    }

    public function getContentEncoding(): string
    {
        return $this->subscription['content-encoding'] ?? 'aesgcm';
    }

    /**
     * @return Collection<int, PushNotification>
     */
    public function getPushNotifications(): Collection
    {
        return $this->pushNotifications;
    }

    public function addPushNotification(PushNotification $pushNotification): static
    {
        if (!$this->pushNotifications->contains($pushNotification)) {
            $this->pushNotifications->add($pushNotification);
            $pushNotification->addSubscription($this);
        }

        return $this;
    }

    public function removePushNotification(PushNotification $pushNotification): static
    {
        if ($this->pushNotifications->removeElement($pushNotification)) {
            $pushNotification->removeSubscription($this);
        }

        return $this;
    }
}

