<?php
namespace App\EventListener;

use App\Entity\User;
use App\Services\AuthenticationRedirect;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;
use Symfony\Component\Routing\RouterInterface;

class RedirectAuthenticatedUserListener
{
    private $tokenStorage;
    private $authorizationChecker;
    private $authenticationRedirect;

    public function __construct(AuthenticationRedirect $authenticationRedirect, TokenStorageInterface $tokenStorage, AuthorizationCheckerInterface $authorizationChecker)
    {
        $this->tokenStorage = $tokenStorage;
        $this->authorizationChecker = $authorizationChecker;
        $this->authenticationRedirect = $authenticationRedirect;
    }

    public function onKernelRequest(RequestEvent $event): void
    {
        /** @var User $user */
        $request = $event->getRequest();

        // Check if the user is authenticated
        if ($this->authorizationChecker->isGranted('IS_AUTHENTICATED')) {
            // Redirect authenticated users away from the login page
            $user = $this->tokenStorage->getToken()->getUser();
            $currentPage = $request->attributes->get('_route');
            if ($this->isOnStrictlyAnonymousPage($currentPage)) {
                $event->setResponse($this->authenticationRedirect->getRedirectResponse($user));
            }
        }
    }
    public function isOnStrictlyAnonymousPage ($currentPage): bool
    {
        return in_array($currentPage, ['app_login', 'app_reset_password', 'app_forgot_password_request',
            'app_check_email', 'app_system_scan_card']);
    }
}