<?php

namespace App\Form\AutocompleteField;

use App\Entity\Educator;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Contracts\Translation\TranslatorInterface;
use Symfony\UX\Autocomplete\Form\AsEntityAutocompleteField;
use Symfony\UX\Autocomplete\Form\BaseEntityAutocompleteType;

#[AsEntityAutocompleteField]
class EducatorAutocompleteField extends AbstractType
{
    private TranslatorInterface $translator;

    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'class' => Educator::class,
            'label' => 'entity.educator.singular_name',
            'placeholder' => 'entity.educator.choose_one',
            'choice_label' => 'user',
            'searchable_fields' => ['user.email'],
            'query_builder' => function (EntityRepository $er) {
                return $er->createQueryBuilder('s')
                    ->addSelect('user_query')
                    ->leftJoin('s.user', 'user_query')
                    ->andWhere('user_query.active = :active')
                    ->setParameter('active', true);
            },
            'no_more_results_text' => $this->translator->trans('autocomplete.no_more_results_text'),
            'no_results_found_text' => $this->translator->trans('autocomplete.no_results_found_text'),
            'loading_more_text' => $this->translator->trans('autocomplete.loading_more_text'),
        ]);
    }
    public function getParent(): string
    {
        return BaseEntityAutocompleteType ::class;
    }
}
