<?php
namespace App\Form;

use App\Entity\StudentNote;
use App\Form\AutocompleteField\EducatorAutocompleteField;
use App\Form\AutocompleteField\StudentAutocompleteField;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CreateStudentNoteType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('note', TextareaType::class, [
            'label' => 'entity.student_note.singular_name'
        ]);

        $builder
            ->add('save', SubmitType::class, [
                'label' => 'general.save',
            ])
        ;
    }
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => StudentNote::class,
        ]);
    }
}