<?php

namespace App\Form\DataTransformer;

use App\Exception\EmptyColumnsInImportStudentsException;
use App\Services\Import\Import;
use Exception;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Exception\TransformationFailedException;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Symfony\Component\Validator\Constraints as Assert;

class FileToStudentDataTransformer implements DataTransformerInterface
{
    const STUDENT_EMAIL_KEY = 'Email';
    const STUDENT_FIRST_NAME_KEY = 'Meno';
    const STUDENT_LAST_NAME_KEY = 'Priezvisko';
    const DATE_OF_BIRTH_KEY = 'Datum narodenia';
    const STREET_KEY = 'Ulica';
    const POSTAL_CODE_KEY = 'PSC';
    const CITY_KEY = 'Mesto';
    const COUNTRY_KEY = 'Krajina';
    const STUDENT_PHONE_KEY = 'Telefon';
    const STUDENT_PHONE_COUNTRY_KEY = 'Telefonna predvolba';
    const SCHOOL_KEY = 'Skola';
    const CLASS_KEY = 'Trieda';
    const EDUCATOR_KEY = 'Vychovavatel';
    const ROOM_KEY = 'Izba';
    const GUARDIAN1_EMAIL_KEY = 'Opatrovnik1 email';
    const GUARDIAN1_FIRST_NAME_KEY = 'Opatrovnik1 meno';
    const GUARDIAN1_LAST_NAME_KEY = 'Opatrovnik1 priezvisko';
    const GUARDIAN1_PHONE_KEY = 'Opatrovnik1 telefon';
    const GUARDIAN1_PHONE_COUNTRY_KEY = 'Opatrovnik1 telefonna predvolba';
    const GUARDIAN2_EMAIL_KEY = 'Opatrovnik2 email';
    const GUARDIAN2_FIRST_NAME_KEY = 'Opatrovnik2 meno';
    const GUARDIAN2_LAST_NAME_KEY = 'Opatrovnik2 priezvisko';
    const GUARDIAN2_PHONE_KEY = 'Opatrovnik2 telefon';
    const GUARDIAN2_PHONE_COUNTRY_KEY = 'Opatrovnik2 telefonna predvolba';
    const GUARDIAN3_EMAIL_KEY = 'Opatrovnik3 email';
    const GUARDIAN3_FIRST_NAME_KEY = 'Opatrovnik3 meno';
    const GUARDIAN3_LAST_NAME_KEY = 'Opatrovnik3 priezvisko';
    const GUARDIAN3_PHONE_KEY = 'Opatrovnik3 telefon';
    const GUARDIAN3_PHONE_COUNTRY_KEY = 'Opatrovnik3 telefonna predvolba';
    const COACH_EMAIL_KEY = 'Trener email';
    const COACH_FIRST_NAME_KEY = 'Trener meno';
    const COACH_LAST_NAME_KEY = 'Trener priezvisko';
    const COACH_PHONE_KEY = 'Trener telefon';
    const COACH_PHONE_COUNTRY_KEY = 'Trener telefonna predvolba';
    const MASTERTEACHER_EMAIL_KEY = 'Triedny email';
    const MASTERTEACHER_FIRST_NAME_KEY = 'Triedny meno';
    const MASTERTEACHER_LAST_NAME_KEY = 'Triedny priezvisko';
    const MASTERTEACHER_PHONE_KEY = 'Triedny telefon';
    const MASTERTEACHER_PHONE_COUNTRY_KEY = 'Triedny telefonna predvolba';
    public function __construct(
        private readonly Import             $import,
        private readonly ValidatorInterface $validator,
    ) {
    }

    /**
     * Transforms an object (array) to a file.
     *
     * @param  $value
     * @return string
     */
    public function transform($value): string
    {
        return "";
    }

    /**
     * Transforms a string (number) to an object (issue).
     *
     * @param  UploadedFile|null $value
     * @throws TransformationFailedException if object (issue) is not found.
     */
    public function reverseTransform($value): ?array
    {
        if ($value === null) {
            return null;
        }
        $seq = [];
        for ($i = 0; $i < ord('M')-ord('A')+1; $i++) {
            $seq[] = 'A' . chr(65 + $i);
        }
        $sequence = array_merge(range('A', 'Z'), $seq);
        try {
            $importedData = $this->import->upload($value, self::getKeys(), $sequence);
            $this->validateStudents($importedData);

        } catch (TransformationFailedException $e){
            throw $e;
        }
        catch (Exception $e){
            $failure = new TransformationFailedException($e->getMessage());
            $failure->setInvalidMessage($e->getMessage());
            throw $failure;
        }
        return $importedData;
    }
    public static function getKeys(): array
    {
        return [self::STUDENT_EMAIL_KEY, self::STUDENT_FIRST_NAME_KEY, self::STUDENT_LAST_NAME_KEY, self::DATE_OF_BIRTH_KEY,
            self::STREET_KEY, self::POSTAL_CODE_KEY, self::CITY_KEY, self::COUNTRY_KEY, self::STUDENT_PHONE_KEY, self::STUDENT_PHONE_COUNTRY_KEY,
            self::SCHOOL_KEY, self::CLASS_KEY, self::EDUCATOR_KEY, self::ROOM_KEY,
            self::GUARDIAN1_EMAIL_KEY, self::GUARDIAN1_FIRST_NAME_KEY, self::GUARDIAN1_LAST_NAME_KEY, self::GUARDIAN1_PHONE_KEY, self::GUARDIAN1_PHONE_COUNTRY_KEY,
            self::GUARDIAN2_EMAIL_KEY, self::GUARDIAN2_FIRST_NAME_KEY, self::GUARDIAN2_LAST_NAME_KEY, self::GUARDIAN2_PHONE_KEY, self::GUARDIAN2_PHONE_COUNTRY_KEY,
            self::GUARDIAN3_EMAIL_KEY, self::GUARDIAN3_FIRST_NAME_KEY, self::GUARDIAN3_LAST_NAME_KEY, self::GUARDIAN3_PHONE_KEY, self::GUARDIAN3_PHONE_COUNTRY_KEY,
            self::COACH_EMAIL_KEY, self::COACH_FIRST_NAME_KEY, self::COACH_LAST_NAME_KEY, self::COACH_PHONE_KEY, self::COACH_PHONE_COUNTRY_KEY,
            self::MASTERTEACHER_EMAIL_KEY, self::MASTERTEACHER_FIRST_NAME_KEY, self::MASTERTEACHER_LAST_NAME_KEY, self::MASTERTEACHER_PHONE_KEY, self::MASTERTEACHER_PHONE_COUNTRY_KEY];
    }

    /**
     * @throws EmptyColumnsInImportStudentsException
     */
    private function validateStudents(array $importedStudents): void
    {
        $invalidEmails = [];
        foreach ($importedStudents as $importedStudent) {
            if (empty($importedStudent[self::STUDENT_EMAIL_KEY]) || empty($importedStudent[self::STUDENT_FIRST_NAME_KEY]) || empty($importedStudent[self::STUDENT_LAST_NAME_KEY]) ||
                empty($importedStudent[self::EDUCATOR_KEY])) {
                throw new EmptyColumnsInImportStudentsException;
            }
            foreach ([$importedStudent[self::STUDENT_EMAIL_KEY], $importedStudent[self::EDUCATOR_KEY]] as $email) {
                $errors = $this->validator->validate($email, new Assert\Email());
                if ($errors->count() > 0) {
                    $invalidEmails[] = $email;
                }
            }
            for ($i = 1; $i <= 3; $i++) {
                if (!empty($importedStudent[constant('self::GUARDIAN'.$i.'_EMAIL_KEY')])) {
                    $errors = $this->validator->validate($importedStudent[constant('self::GUARDIAN'.$i.'_EMAIL_KEY')], new Assert\Email());
                    if ($errors->count() > 0) {
                        $invalidEmails[] = $importedStudent[constant('self::GUARDIAN'.$i.'_EMAIL_KEY')];
                    }
                    if (empty($importedStudent[constant('self::GUARDIAN'.$i.'_FIRST_NAME_KEY')]) || empty($importedStudent[constant('self::GUARDIAN'.$i.'_LAST_NAME_KEY')])) {
                        throw new EmptyColumnsInImportStudentsException;
                    }
                }
            }


        }
        if (!empty($invalidEmails)) {
            throw new TransformationFailedException('', 0, null, 'data_transformer.invalid_email_address', [
                '%email%' => implode(', ', $invalidEmails),
            ]);
        }
    }
}
