<?php
namespace App\Form;

use App\Entity\Educator;
use App\Entity\Schedule;
use App\Form\AutocompleteField\EducatorAutocompleteField;
use App\Services\GeneralFunctionsService;
use Doctrine\ORM\EntityRepository;
use Exception;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class EntityScheduleType extends AbstractType
{
    private int $app_week_cycle;

    public function __construct(int $app_week_cycle)
    {

        $this->app_week_cycle = $app_week_cycle;
    }

    /**
     * @throws Exception
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('educator', EducatorAutocompleteField::class, [
            'constraints' => [
                new NotBlank(),
            ],
        ]);
        $choices = [];
        for ($i = 0; $i < $this->app_week_cycle; $i++) {
            $choices[$i+1] = ($i+1)%$this->app_week_cycle;
        }
        $builder->add('week', ChoiceType::class, [
            'label' => 'entity.schedule.week',
            'placeholder' => 'entity.schedule.choose_week',
            'choices' => $choices,
            'constraints' => [
                new NotBlank(),
            ],
        ]);
        $choices = [];
        for ($i = 0; $i < 7; $i++) {
            $choices[GeneralFunctionsService::dayInWeekToString($i)] = $i;
        }
        $builder->add('dayInWeek', ChoiceType::class, [
            'label' => 'general.day',
            'placeholder' => 'entity.schedule.choose_day',
            'choices' => $choices,
            'constraints' => [
                new NotBlank(),
            ],
        ]);
        Schedule::initFromTimeAndToTime();
        $builder->add('fromTime', ChoiceType::class, [
            'label' => 'entity.schedule.from',
            'placeholder' => 'entity.schedule.choose_from',
            'choices' => Schedule::$FROM_TIME,
            'help' => 'entity.schedule.choose_help_emergency',
        ]);

        $builder->add('toTime', ChoiceType::class, [
            'label' => 'entity.schedule.to',
            'placeholder' => 'entity.schedule.choose_to',
            'choices' => Schedule::$TO_TIME,
            'help' => 'entity.schedule.choose_help_emergency',
        ]);

        $builder
            ->add('save', SubmitType::class, [
                'label' => 'general.save',
            ])
        ;
    }
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Schedule::class,
        ]);
    }
}