<?php
namespace App\Form;

use App\Entity\Educator;
use App\Form\AutocompleteField\EducatorAutocompleteField;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\WeekType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Translation\TranslatableMessage;
use Symfony\Component\Validator\Constraints\Callback;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

class FilterScheduleType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $minYear = $builder->getData()['minYear'];
        $educator = $builder->getData()['educator'];
        $builder->add('educator', EducatorAutocompleteField::class, [
            'data' => $educator,
            'constraints' => [
                new NotBlank(),
            ],
        ]);

        $builder->add('week', WeekType::class, [
            'label' => 'entity.schedule.week',
            'placeholder' => 'entity.schedule.choose_week',
            'data' => [
                'year' => (int) date('Y'),
                'week' => (int) date('W'),
            ],
            'constraints' => [
                new NotBlank(),
                new Callback(function ($value, ExecutionContextInterface $context) use ($minYear) {
                    if ($value['year'] < $minYear) {
                        $context->buildViolation(new TranslatableMessage('entity.schedule.choose_after_year', [
                            '%minYear%' => $minYear,
                        ]))
                            ->atPath('week')
                            ->addViolation();
                    }
                }),
            ],
        ]);

        $builder
            ->add('save', SubmitType::class, [
                'label' => 'general.filter',
            ])
        ;
    }
}