<?php
namespace App\Form\FilterType;

use App\Entity\Attendance;
use App\Entity\Activity;
use App\Services\GeneralFunctionsService;
use Exception;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Contracts\Translation\TranslatorInterface;

class DayInWeekFilterType extends AbstractType
{
    private TranslatorInterface $translator;


    public function __construct(TranslatorInterface $translator)
    {

        $this->translator = $translator;
    }
    /**
     * @throws Exception
     */
    public function configureOptions(OptionsResolver $resolver): void
    {
        $choices = [];
        for ($i = 0; $i < 7; $i++) {
            $choices[$this->translator->trans(GeneralFunctionsService::dayInWeekToString($i))] = $i;
        }
        $resolver->setDefaults([
            'choices' => $choices,
        ]);
    }

    public function getParent(): string
    {
        return ChoiceType::class;
    }
}