<?php
namespace App\Form\FilterType;

use App\Repository\RoomRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RoomFloorFilterType extends AbstractType
{
    private RoomRepository $roomRepository;

    public function __construct(RoomRepository $roomRepository)
    {

        $this->roomRepository = $roomRepository;
    }
    public function configureOptions(OptionsResolver $resolver): void
    {
        $floors = $this->roomRepository->findDistinctFloors();
        $choices = [];
        foreach ($floors as $floor){
            $choices[sprintf('%d.', $floor)] = $floor;
        }
        $resolver->setDefaults([
            'choices' => $choices,
        ]);
    }

    public function getParent(): string
    {
        return ChoiceType::class;
    }
}