<?php

namespace App\Form\FilterType;

use App\Repository\StudentRepository;
use EasyCorp\Bundle\EasyAdminBundle\Form\Filter\Type\ChoiceFilterType;
use EasyCorp\Bundle\EasyAdminBundle\Form\Type\ComparisonType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class StudentMeetingFilterType extends AbstractType
{
    private StudentRepository $studentRepository;

    public function __construct(StudentRepository $studentRepository)
    {

        $this->studentRepository = $studentRepository;
    }
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('comparison', HiddenType::class, [
                'data' => ComparisonType::EQ,
            ])
        ;
    }
    public function configureOptions(OptionsResolver $resolver): void
    {
        $students = $this->studentRepository->findAllJoinedActiveUser();
        $choices = [];
        foreach ($students as $student){
            $choices[sprintf('%s %s', $student->getUser()->getFirstName(), $student->getUser()->getLastName())] = $student;
        }
        $resolver->setDefaults([
            'value_type' => ChoiceType::class,
            'value_type_options' => [
                'choices' => $choices,
                'multiple' => false
            ],
        ]);
    }
    public function getParent(): string
    {
        return ChoiceFilterType::class;
    }
}