<?php

namespace App\Form\Import;

use App\Form\DataTransformer\FileToTrainingDataTransformer;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Event\PreSubmitEvent;
use Symfony\Component\Form\Exception\TransformationFailedException;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Validator\Constraints\File;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Validator\ValidatorInterface;

class ImportTrainingType extends AbstractType
{
    public function __construct(
        private readonly FileToTrainingDataTransformer $transformer,
        private readonly ValidatorInterface $validator,

    ) {
    }
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('uploadedFile', FileType::class, [
                'label' => 'general.import',
                'mapped' => false,
                // constraints moved to PRE_SUBMIT because DataTransformer
            ])
            ->add('submit', SubmitType::class, [
                'label' => 'general.submit',
            ]);
        $builder->get('uploadedFile')
            ->addModelTransformer($this->transformer);

        $builder->get('uploadedFile')
            ->addEventListener(FormEvents::PRE_SUBMIT, function(PreSubmitEvent $event) {
                $data = $event->getData();

                if ($errors = $this->validator->validate($data, [
                    new NotBlank(),
                    new File([
                        'maxSize' => '1024k',
                        'mimeTypes' => [
                            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",

                        ],
                        'mimeTypesMessage' => 'import.wrong_type',
                    ])
                ])) {
                    foreach ($errors as $error) {
                        $failure = new TransformationFailedException($error->getMessage());
                        $failure->setInvalidMessage($error->getMessage());
                        throw $failure;
                    }
                }
            });
    }
}