<?php
namespace App\Form\Meeting;

use App\Entity\MeetingAttendance;
use App\Repository\MeetingAttendanceRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MeetingAttendanceType extends AbstractType
{
    private MeetingAttendanceRepository $meetingAttendanceRepository;

    public function __construct(MeetingAttendanceRepository $meetingAttendanceRepository)
    {

        $this->meetingAttendanceRepository = $meetingAttendanceRepository;
    }
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event) {
            /** @var MeetingAttendance|null $meetingAttendance */
            $meetingAttendance = $event->getData();
            $form = $event->getForm();

            if ($meetingAttendance !== null) {
                $student = $this->meetingAttendanceRepository->findStudentBasedOnMeetingAttendanceId($meetingAttendance->getId())->getStudent();

                $form->add('present', CheckboxType::class, [
                    'label' => $student,
                    'label_attr' => [
                        'class' => 'checkbox-inline checkbox-switch',
                    ],
                ]);
            }
        });
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => MeetingAttendance::class,
        ]);
    }
}