<?php
namespace App\Form\Meeting;

use App\Entity\Meeting;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MeetingType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('meetingAttendances', CollectionType::class, [
            'label' => 'entity.meeting.attendance',
            'entry_type' => MeetingAttendanceType::class,
            'by_reference' => false,
        ]);

        $builder
            ->add('save', SubmitType::class, [
                'label' => 'general.save',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Meeting::class,
        ]);
    }
}