<?php
namespace App\Form\Meeting;

use App\Entity\Educator;
use App\Entity\Meeting;
use App\Entity\Student;
use App\Form\AutocompleteField\EducatorAutocompleteField;
use DateTimeImmutable;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class NonIndividualMeetingType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $date = new DateTimeImmutable();
        $builder->add('educator', EducatorAutocompleteField::class, [
            'constraints' => [
                new NotBlank(),
            ],
            'mapped' => true,
        ]);
        $builder->add('plannedDate', DateTimeType::class, [
            'label' => 'entity.meeting.planned_date',
            'widget' => 'single_text',
            'input' => 'datetime_immutable',
            'attr' => [
                'min' => $date->format('Y-m-d H:i'),
            ],
            'constraints' => [
                new NotBlank(),
            ],
        ]);
        $builder->add('doorNumber', NumberType::class, [
            'label' => 'entity.meeting.door_number',
            'constraints' => [
                new NotBlank(),
            ],
        ]);
        $builder->add('educatorNote', TextType::class, [
            'label' => 'entity.meeting.educator_note',
        ]);
        $builder->add('studentNote', TextType::class, [
            'label' => 'entity.meeting.student_note',
        ]);

        $builder->add('save', SubmitType::class, [
            'label' => 'general.save',
        ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Meeting::class,
        ]);
    }
}