<?php
namespace App\Form;

use App\Entity\DormitoryCard;
use App\Form\AutocompleteField\StudentAutocompleteField;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UpdateDormitoryCardType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('student', StudentAutocompleteField::class);

        $builder
            ->add('save', SubmitType::class, [
                'label' => 'general.save',
            ])
        ;
    }
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => DormitoryCard::class,
        ]);
    }
}