<?php

namespace App\Repository;

use App\Entity\Activity;
use DateTimeImmutable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Activity>
 *
 * @method Activity|null find($id, $lockMode = null, $lockVersion = null)
 * @method Activity|null findOneBy(array $criteria, array $orderBy = null)
 * @method Activity[]    findAll()
 * @method Activity[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ActivityRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Activity::class);
    }

    public function findTrainingsByStudents(array $students)
    {
        return $this->createQueryBuilder('t')
            ->leftJoin('t.students', 's')
            ->andWhere('s.id IN (:students)')
            ->andWhere('t.type = :training')
            ->setParameter('training', Activity::TRAINING)
            ->setParameter('students', $students)
            ->getQuery()
            ->getResult();
    }

    public function findTrainingsByStudentsAndDay(array $students, DateTimeImmutable $date)
    {
        return $this->createQueryBuilder('t')
            ->leftJoin('t.students', 's')
            ->andWhere('s.id IN (:students)')
            ->andWhere('t.type = :training')
            ->andWhere('t.dayInWeek = :dayInWeek')
            ->setParameter('training', Activity::TRAINING)
            ->setParameter('students', $students)
            ->setParameter('dayInWeek', $date->format('w'))
            ->getQuery()
            ->getResult();
    }
}
