<?php

namespace App\Repository;

use App\Entity\DormitoryCard;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\QueryBuilder;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<DormitoryCard>
 *
 * @method DormitoryCard|null find($id, $lockMode = null, $lockVersion = null)
 * @method DormitoryCard|null findOneBy(array $criteria, array $orderBy = null)
 * @method DormitoryCard[]    findAll()
 * @method DormitoryCard[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class DormitoryCardRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, DormitoryCard::class);
    }
    public function findActiveCards(): array|float|int|string
    {
        return $this->createQueryBuilder('c')
            ->select('c.number')
            ->andWhere('c.student IS NOT NULL')
            ->getQuery()
            ->getSingleColumnResult();
    }
    public function getActiveCardsWithStudentsWithSearchQueryBuilder(?string $term): QueryBuilder
    {
        $qb = $this->createQueryBuilder('c')
            ->addSelect('student', 'user')
            ->leftJoin('c.student', 'student')
            ->leftJoin('student.user', 'user')
            ->andWhere('c.student IS NOT NULL');
        if ($term) {
            $qb->andWhere('(user.firstName LIKE :term OR user.lastName LIKE :term OR user.email LIKE :term OR c.number LIKE :term)')
                ->setParameter('term', '%' . $term . '%')
            ;
        }
        return $qb
            ->addOrderBy('user.lastName', 'ASC')
            ->addOrderBy('user.firstName', 'ASC')
            ;
    }

    public function getCardsWithoutStudentWithSearchQueryBuilder(?string $term): QueryBuilder
    {
        $qb = $this->createQueryBuilder('c')
            ->andWhere('c.student IS NULL');
        if ($term) {
            $qb->andWhere('(c.number LIKE :term)')
                ->setParameter('term', '%' . $term . '%')
            ;
        }
        return $qb
            ->addOrderBy('c.creationTime', 'DESC')
            ;
    }
}
