<?php

namespace App\Repository;

use App\Entity\Educator;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Educator>
 *
 * @method Educator|null find($id, $lockMode = null, $lockVersion = null)
 * @method Educator|null findOneBy(array $criteria, array $orderBy = null)
 * @method Educator[]    findAll()
 * @method Educator[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class EducatorRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Educator::class);
    }

    /**
     * @throws NonUniqueResultException
     */
    public function findOneByEmail(string $email)
    {
        return $this->createQueryBuilder('e')
            ->leftJoin('e.user', 'u')
            ->andWhere('u.email = :email')
            ->setParameter('email', $email)
            ->getQuery()
            ->getOneOrNullResult();
    }
}
