<?php

namespace App\Repository;

use App\Entity\Guardian;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Guardian>
 *
 * @method Guardian|null find($id, $lockMode = null, $lockVersion = null)
 * @method Guardian|null findOneBy(array $criteria, array $orderBy = null)
 * @method Guardian[]    findAll()
 * @method Guardian[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class GuardianRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Guardian::class);
    }

    /**
     * @throws NonUniqueResultException
     */
    public function findOneByEmail(string $email)
    {
        return $this->createQueryBuilder('e')
            ->leftJoin('e.user', 'u')
            ->andWhere('u.email = :email')
            ->setParameter('email', $email)
            ->getQuery()
            ->getOneOrNullResult();
    }
}
