<?php

namespace App\Repository;

use App\Entity\MasterTeacher;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<MasterTeacher>
 *
 * @method MasterTeacher|null find($id, $lockMode = null, $lockVersion = null)
 * @method MasterTeacher|null findOneBy(array $criteria, array $orderBy = null)
 * @method MasterTeacher[]    findAll()
 * @method MasterTeacher[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class MasterTeacherRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, MasterTeacher::class);
    }

    /**
     * @throws NonUniqueResultException
     */
    public function findOneByEmail(string $email)
    {
        return $this->createQueryBuilder('e')
            ->leftJoin('e.user', 'u')
            ->andWhere('u.email = :email')
            ->setParameter('email', $email)
            ->getQuery()
            ->getOneOrNullResult();
    }
}
