<?php

namespace App\Repository;

use App\Entity\MeetingAttendance;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<MeetingAttendance>
 *
 * @method MeetingAttendance|null find($id, $lockMode = null, $lockVersion = null)
 * @method MeetingAttendance|null findOneBy(array $criteria, array $orderBy = null)
 * @method MeetingAttendance[]    findAll()
 * @method MeetingAttendance[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class MeetingAttendanceRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, MeetingAttendance::class);
    }

    /**
     * @throws NonUniqueResultException
     */
    public function findStudentBasedOnMeetingAttendanceId($meetingAttendanceId)
    {
       return $this->createQueryBuilder('ma')
           ->select('ma', 'student', 'user')
           ->leftJoin('ma.student', 'student')
           ->leftJoin('student.user', 'user')
           ->andWhere('ma.id = :meeting')
           ->setParameter('meeting', $meetingAttendanceId)
           ->getQuery()
           ->getOneOrNullResult();
    }
}
