<?php

namespace App\Repository;

use App\Entity\Meeting;
use DateTimeImmutable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\NoResultException;
use Doctrine\ORM\QueryBuilder;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Meeting>
 *
 * @method Meeting|null find($id, $lockMode = null, $lockVersion = null)
 * @method Meeting|null findOneBy(array $criteria, array $orderBy = null)
 * @method Meeting[]    findAll()
 * @method Meeting[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class MeetingRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Meeting::class);
    }

    public function findTodayMeetings(DateTimeImmutable $date)
    {
        return $this->createQueryBuilder('m')
            ->andWhere('DATE(m.plannedDate) = :date')
            ->setParameter('date', $date->format('Y-m-d'))
            ->getQuery()
            ->getResult();
    }

    /**
     * @throws NonUniqueResultException
     */
    public function findMeetingById(int $meetingId)
    {
        return $this->createQueryBuilder('m')
            ->addSelect('ma', 'student', 'user')
            ->leftJoin('m.meetingAttendances', 'ma')
            ->leftJoin('ma.student', 'student')
            ->leftJoin('student.user', 'user')
            ->andWhere('m.id = :id')
            ->setParameter('id', $meetingId)
            ->getQuery()
            ->getOneOrNullResult();
    }
}
