<?php

namespace App\Repository;

use App\Entity\MessageReceiver;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<MessageReceiver>
 *
 * @method MessageReceiver|null find($id, $lockMode = null, $lockVersion = null)
 * @method MessageReceiver|null findOneBy(array $criteria, array $orderBy = null)
 * @method MessageReceiver[]    findAll()
 * @method MessageReceiver[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class MessageReceiverRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, MessageReceiver::class);
    }
    public function findUnsentMessagesForReceivers()
    {
        return $this->createQueryBuilder('mr')
            ->andWhere('mr.sent = :sent')
            ->setParameter('sent', false)
            ->getQuery()
            ->getResult();
    }
}
