<?php

namespace App\Repository;

use App\Entity\Educator;
use App\Entity\Room;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\NoResultException;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Room>
 *
 * @method Room|null find($id, $lockMode = null, $lockVersion = null)
 * @method Room|null findOneBy(array $criteria, array $orderBy = null)
 * @method Room[]    findAll()
 * @method Room[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class RoomRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Room::class);
    }
    public function findDistinctFloors(): array
    {
        return $this->createQueryBuilder('r')
            ->select('r.floor')
            ->distinct()
            ->addOrderBy('r.floor', 'ASC')
            ->getQuery()
            ->getSingleColumnResult();
    }
    public function findDistinctFloorsForEducator(Educator $educator): array
    {
        return $this->createQueryBuilder('r')
            ->select('r.floor')
            ->distinct()
            ->addOrderBy('r.floor', 'ASC')
            ->leftJoin('r.students', 'students')
            ->leftJoin('students.educator', 'educator')
            ->leftJoin('students.user', 'user')
            ->andWhere('user.active = :active')
            ->setParameter('active', 1)
            ->andWhere('educator.id = :educatorId')
            ->setParameter('educatorId', $educator->getId())
            ->getQuery()
            ->getSingleColumnResult();
    }
}
