<?php

namespace App\Repository;

use App\Entity\Educator;
use App\Entity\Schedule;
use App\Services\ScheduleService;
use DateTimeImmutable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Exception;

/**
 * @extends ServiceEntityRepository<Schedule>
 *
 * @method Schedule|null find($id, $lockMode = null, $lockVersion = null)
 * @method Schedule|null findOneBy(array $criteria, array $orderBy = null)
 * @method Schedule[]    findAll()
 * @method Schedule[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ScheduleRepository extends ServiceEntityRepository
{
    private int $app_week_cycle;

    public function __construct(int $app_week_cycle, ManagerRegistry $registry)
    {
        parent::__construct($registry, Schedule::class);
        $this->app_week_cycle = $app_week_cycle;
    }

    /**
     * @throws Exception
     */
    public function findScheduleForDate(DateTimeImmutable $date): array
    {
        $week = [
            'week' => $date->format('W'),
            'year' => $date->format('Y'),
        ];
        $schoolWeek = ScheduleService::findSchoolWeek($week);
        $weekOfCycle = ScheduleService::getWeekOfCycle($week, $schoolWeek, $this->app_week_cycle);
        return $this->findBy([
            'week' => $weekOfCycle,
            'dayInWeek' => $date->format('w'),], ['fromTime' => 'ASC']);
    }

    public function removeSchedulesByEducator(Educator $educator): void
    {
        $schedules = $this->findBy(['educator' => $educator]);

        foreach ($schedules as $schedule) {
            $this->getEntityManager()->remove($schedule);
        }
    }
    public function removeAllSchedules(): void
    {
        $schedules = $this->findAll();

        foreach ($schedules as $schedule) {
            $this->getEntityManager()->remove($schedule);
        }
    }
}
