<?php

namespace App\Serializer;

use App\Entity\Student;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class StudentNormalizer implements NormalizerInterface
{

    public function normalize(mixed $object, string $format = null, array $context = []): array
    {
        /* @var Student $object*/
        return [
            'id' => $object->getId(),
            'email' => $object->getUser()->getEmail(),
            'meno' => $object->getUser()->getFirstName(),
            'priezvisko' => $object->getUser()->getLastName(),
            'datum narodenia' => $object->getDateOfBirth()->format('Y-m-d'),
            'telefon' => '+'. $object->getUser()->getPhoneNumber(),
            'vychovavatel' => $object->getEducator(),
            'izba' => $object->getRoom()->getDoorNumber(),
            'skola' => $object->getClassroom() === null? 'N/A' : $object->getClassroom()->getSchool()->getName(),
            'trieda' => $object->getClassroom() === null? 'N/A' : $object->getClassroom()->getName(),
        ];
    }

    public function supportsNormalization(mixed $data, string $format = null): bool
    {
        return $data instanceof Student;
    }
}