<?php

namespace App\Services;

use App\Entity\User;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;

class AuthenticationRedirect
{
    private RouterInterface $router;

    public function __construct(RouterInterface $router)
    {
        $this->router = $router;
    }

    public function getRedirectResponse(User $user): RedirectResponse
    {
        if ($user->hasRole(User::ROLE_ADMIN)){
            return new RedirectResponse(
                $this->router->generate('admin')
            );
        }
        if ($user->hasRole(User::ROLE_EDUCATOR)){
            return new RedirectResponse(
                $this->router->generate('educator')
            );
        }
        if ($user->hasRole(User::ROLE_GUARDIAN)){
            return new RedirectResponse(
                $this->router->generate('guardian')
            );
        }
        if ($user->hasRole(User::ROLE_STUDENT)){
            return new RedirectResponse(
                $this->router->generate('student')
            );
        }
        throw new AuthenticationException('Unknown user role.');
    }
}