<?php

namespace App\Services;

use App\Entity\Attendance;
use App\Entity\Activity;
use DateTimeImmutable;

class DailyAttendance
{
    private DateTimeImmutable $day;
    private ?DateTimeImmutable $eveningCheck = null;
    private ?Attendance $currentAttendance = null;
    private array $otherAttendances = [];
    private array $activities = [];

    public function __construct(DateTimeImmutable $day) {

        $this->day = $day;
    }

    public function getDay(): DateTimeImmutable
    {
        return $this->day;
    }

    public function getEveningCheck(): ?DateTimeImmutable
    {
        return $this->eveningCheck;
    }

    public function setEveningCheck(?DateTimeImmutable $eveningCheck): void
    {
        $this->eveningCheck = $eveningCheck;
    }

    public function getCurrentAttendance(): ?Attendance
    {
        return $this->currentAttendance;
    }

    public function setCurrentAttendance(?Attendance $currentAttendance): void
    {
        $this->currentAttendance = $currentAttendance;
    }

    public function getOtherAttendances(): array
    {
        return $this->otherAttendances;
    }

    public function addOtherAttendance(Attendance $otherAttendance): void
    {
        $this->otherAttendances[] = $otherAttendance;
    }
    public function getActivities(): array
    {
        return $this->activities;
    }

    public function addActivity(Activity $activity): void
    {
        $this->activities[] = $activity;
    }
}