<?php

namespace App\Services\Import;

use App\Exception\EmptyFileException;
use App\Exception\WrongExcelKeysException;
use PhpOffice\PhpSpreadsheet\IOFactory;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class Import
{
    /**
     * @throws WrongExcelKeysException
     * @throws EmptyFileException
     */
    public function upload(UploadedFile $file, array $keys, array $sequence): array
    {
        $spreadsheet = IOFactory::load($file->getRealPath());
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
        $sheetData = array_filter($sheetData, function($row) {
            return !empty(array_filter($row, function($cell) {
                return $cell !== null;
            }));
        });

        $importedData = [];
        if (isset($sheetData[1])) {
            $headers = $sheetData[1];
            foreach ($keys as $i => $key) {
                if ($headers[$sequence[$i]] !== $key) {
                    throw new WrongExcelKeysException;
                }
            }
            unset($sheetData[1]);

            foreach ($sheetData as $row) {
                $columns = [];
                foreach ($keys as $i => $key) {
                    $columns[$key] = $row[$sequence[$i]];
                }
                $importedData[] = $columns;
            }
        }
        if (count($importedData) === 0) {
            throw new EmptyFileException;
        }
        return $importedData;
    }
}