<?php

namespace App\Services;


use ReflectionClass;
use ReflectionException;
use Symfony\Component\HttpKernel\KernelInterface;

class MpdfService
{
    private string $cacheDir;

    public function __construct(KernelInterface $kernel)
    {
        $this->cacheDir = $kernel->getCacheDir();
    }

    /**
     * @throws ReflectionException
     */
    public function setMpdf($constructorArgs = [])
    {
        $allConstructorArgs = $constructorArgs;
        $allConstructorArgs = [array_merge([
            'mode' => 'utf-8',
            'format' => 'A4',
            'tempDir' => $this->cacheDir,
            'setAutoTopMargin' => 'stretch',
        ], $allConstructorArgs)];

        $reflection = new ReflectionClass('Mpdf\Mpdf');
        return $reflection->newInstanceArgs($allConstructorArgs);
    }
}