<?php

namespace App\Services;


use App\Services\PushNotification\PushMessageSender;
use BenTools\WebPushBundle\Model\Message\PushNotification;
use Doctrine\ORM\EntityManagerInterface;
use ErrorException;

class PushNotifier
{

    private UserSubscriptionManager $userSubscriptionManager;
    private PushMessageSender $sender;
    private EntityManagerInterface $entityManager;

    public function __construct(UserSubscriptionManager $userSubscriptionManager, PushMessageSender $sender, EntityManagerInterface $entityManager)
    {

        $this->userSubscriptionManager = $userSubscriptionManager;
        $this->sender = $sender;
        $this->entityManager = $entityManager;
    }
    public function saveNewNotification(PushNotification $push, array $subscriptions): void
    {
        $pushNotification = new \App\Entity\PushNotification();
        $pushNotification->setTitle($push->getTitle());
        $pushNotification->setOptions($push->getOptions());
        $pushNotification->setSent(false);
        foreach ($subscriptions as $subscription) {
            $pushNotification->addSubscription($subscription);
        }
        $this->entityManager->persist($pushNotification);
    }

    /**
     * @throws ErrorException
     */
    public function sendNotification (\App\Entity\PushNotification $pushNotification): void
    {
        $notification = new PushNotification($pushNotification->getTitle(), $pushNotification->getOptions());
        $defaultOptions = [
            'TTL' => 60*60*24*7, // defaults to 4 weeks
            'urgency' => 'normal', // protocol defaults to "normal"
            'topic' => 'new_event', // not defined by default,
            'batchSize' => 200, // defaults to 1000
        ];
        $this->sender->setDefaultOptions($defaultOptions);
        $responses = $this->sender->push($notification->createMessage(), $pushNotification->getSubscriptions());
        $pushNotification->setSent(true);
        foreach ($responses as $response) {
            if ($response->isExpired()) {
                $this->userSubscriptionManager->delete($response->getSubscription());
            }
        }
        $this->entityManager->flush();
    }
}