<?php

namespace App\Services;

use App\Entity\User;
use App\Entity\UserSubscription;
use App\Repository\UserSubscriptionRepository;
use BenTools\WebPushBundle\Model\Subscription\UserSubscriptionInterface;
use Doctrine\ORM\EntityManagerInterface;

class UserSubscriptionManager
{

    private UserSubscriptionRepository $userSubscriptionRepository;
    private EntityManagerInterface $entityManager;

    public function __construct(UserSubscriptionRepository $userSubscriptionRepository, EntityManagerInterface $entityManager)
    {
        $this->userSubscriptionRepository = $userSubscriptionRepository;
        $this->entityManager = $entityManager;
    }

    public function factory(User $user, string $subscriptionHash, array $subscription, array $options = []): UserSubscriptionInterface
    {
        // $options is an arbitrary array that can be provided through the front-end code.
        // You can use it to store meta-data about the subscription: the user agent, the referring domain, ...
        return new UserSubscription($user, $subscriptionHash, $subscription);
    }

    public function hash(string $endpoint): string {
        return md5($endpoint); // Encode it as you like
    }

    public function getUserSubscription(User $user, string $subscriptionHash): ?UserSubscriptionInterface
    {
        return $this->userSubscriptionRepository->findOneBy([
            'user' => $user,
            'subscriptionHash' => $subscriptionHash,
        ]);
    }

    public function findByUser(User $user): iterable
    {
        return $this->userSubscriptionRepository->findBy([
            'user' => $user,
        ]);
    }

    public function findByHash(string $subscriptionHash): iterable
    {
        return $this->userSubscriptionRepository->findBy([
            'subscriptionHash' => $subscriptionHash,
        ]);
    }

    public function save(UserSubscriptionInterface $userSubscription): void
    {
        $this->entityManager->persist($userSubscription);
        $this->entityManager->flush();
    }

    public function delete(UserSubscriptionInterface $userSubscription): void
    {
        $this->entityManager->remove($userSubscription);
        $this->entityManager->flush();
    }

}