<?php

namespace App\Validator\Constraints;

use App\Entity\User;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Twilio\Exceptions\RestException;
use Twilio\Exceptions\TwilioException;
use Twilio\Rest\Client;

class E164NumberValidator extends ConstraintValidator
{
    private Client $twilio;

    public function __construct(Client $twilio)
    {
        $this->twilio = $twilio;
    }

    public function validate($value, Constraint $constraint): void
    {
        /** @var User $value */
        if ($value->getPhoneNumber() !== null && $value->getPhoneCountry() !== null) {
            try {
                $number = $this->twilio->lookups->v1
                    ->phoneNumbers($value->getPhoneNumber())
                    ->fetch(['countryCode' => $value->getPhoneCountry()]);

                //set transformed phoneNumber
                $value->setPhoneNumber($number->phoneNumber);
                //in case user use +421, 00421 as country code, but select another country .. we reset countryCode
                $value->setPhoneCountry($number->countryCode);
            } catch (RestException|TwilioException $e) {
                $this->context
                    ->buildViolation($constraint->invalidNumberMessage)
                    ->atPath('phoneNumber')
                    ->addViolation();
            }
        }
    }
}