<?php
namespace App\Validator\Constraints;

use App\Entity\Activity;
use App\Entity\Schedule;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

class FromTimeIsLessThanEndTimeValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint): void
    {
        if ($value === null) {
            return;
        }
        if (!$value instanceof Activity) {
            throw new UnexpectedTypeException($value, Activity::class);
        }
        if ($value->getFromTime()->format('H:i') > $value->getToTime()->format('H:i')) {
            $this->context->buildViolation($constraint->message)
                ->atPath('toTime')
                ->addViolation();
        }
    }
}