<?php
namespace App\Validator\Constraints;

use App\Entity\Attendance;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

class LeaveValidUntilDifferentDayAsTimeValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint): void
    {
        if ($value === null) {
            return;
        }
        if (!$value instanceof Attendance) {
            throw new UnexpectedTypeException($value, Attendance::class);
        }
        if ($value->getAction() !== Attendance::DEPARTURE) {
            return;
        }
        if ($value->getTime()->format('Y-m-d') >= $value->getValidUntil()->format('Y-m-d')) {
            $this->context->buildViolation($constraint->message)
                ->atPath('validUntil')
                ->addViolation();
        }
    }

}