<?php
namespace App\Validator\Constraints;

use App\Entity\Attendance;
use App\Entity\Student;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

class NonActiveStudentNoRoomValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint): void
    {
        if ($value === null) {
            return;
        }
        if (!$value instanceof Student) {
            throw new UnexpectedTypeException($value, Student::class);
        }
        if ($value->getUser()->isActive() === true) {
            return;
        }
        if ($value->getRoom() === null) {
            return;
        }

        $this->context->buildViolation($constraint->message)
            ->atPath('room')
            ->addViolation();

    }

}