<?php
namespace App\Validator\Constraints;

use App\Entity\Schedule;
use App\Services\ScheduleService;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

class TimeScheduleValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint): void
    {
        if ($value === null) {
            return;
        }
        if (!$value instanceof Schedule ) {
            throw new UnexpectedTypeException($value, Schedule::class);
        }
        if ($value->getFromTime() === null && $value->getToTime() !== null) {
            $this->context->buildViolation('validator.emergency_schedule')
                ->atPath('toTime')
                ->addViolation();
            return;
        }
        if ($value->getFromTime() !== null && $value->getToTime() === null) {
            $this->context->buildViolation('validator.emergency_schedule')
                ->atPath('fromTime')
                ->addViolation();
            return;
        }
        if ($value->getFromTime() === null && $value->getToTime() === null) {
            return;
        }
        if (!ScheduleService::isValidTimeCombination($value->getFromTime()->format('H:i'), $value->getToTime()->format('H:i'))) {
            $this->context->buildViolation($constraint->message)
                ->atPath('toTime')
                ->addViolation();
        }
    }

}