<?php
namespace App\Validator\Constraints;

use App\Entity\Room;
use App\Entity\Student;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;
use Doctrine\Common\Collections\Collection;

class TwoStudentsInOneRoomValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint): void
    {
        if ($value === null) {
            return;
        }
        if (!$value instanceof Student) {
            throw new UnexpectedTypeException($value, Student::class);
        }
        if ($value->getRoom() === null) {
            return;
        }
        foreach ($value->getRoom()->getStudents() as $student) {
            if ($student->getId() === $value->getId()) {
                return;
            }
        }
        if ($value->getRoom()->getStudents()->count() >= 2) {
            $this->context->buildViolation($constraint->message)
                ->atPath('room')
                ->addViolation();
        }
    }

}