<?php
namespace App\Validator\Constraints;

use App\Entity\Attendance;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

class WalkValidUntilSameDayAsTimeValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint): void
    {
        if ($value === null) {
            return;
        }
        if (!$value instanceof Attendance) {
            throw new UnexpectedTypeException($value, Attendance::class);
        }
        if ($value->getAction() !== Attendance::WALK) {
            return;
        }
        if ($value->getTime()->format('Y-m-d') !== $value->getValidUntil()->format('Y-m-d')) {
            $this->context->buildViolation($constraint->message)
                ->atPath('validUntil')
                ->addViolation();
        }
        if ($value->getTime()->format('H:i') > $value->getValidUntil()->format('H:i')) {
            $this->context->buildViolation('validator.valid_until_greater_than_time')
                ->atPath('validUntil')
                ->addViolation();
        }
    }

}